﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class NewsLettersDB
    {
        public static NewsLetters GetItem(Guid newsLettersID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@NewsLettersID", ((newsLettersID != Guid.Empty && newsLettersID != null) ? newsLettersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<NewsLetters>("spGetNewsLetters", parameters);
        }

        public static List<NewsLetters> GetList(Guid newsLettersID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@NewsLettersID", ((newsLettersID != Guid.Empty && newsLettersID != null) ? newsLettersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<NewsLetters>("spGetNewsLetters", parameters);
        }

        public static DataTable GetDataTable(Guid newsLettersID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@NewsLettersID", ((newsLettersID != Guid.Empty && newsLettersID != null) ? newsLettersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetNewsLetters", parameters);
        }

        public static DataSet GetDataSet(Guid newsLettersID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@NewsLettersID", ((newsLettersID != Guid.Empty && newsLettersID != null) ? newsLettersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetNewsLetters", parameters);
        }

        public static void Save(NewsLetters myNewsLetter)
        {
            myNewsLetter.Mode = ((myNewsLetter.UniqueID != Guid.Empty && myNewsLetter.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myNewsLetter.UniqueID = ((myNewsLetter.UniqueID != Guid.Empty && myNewsLetter.UniqueID != null) ? myNewsLetter.UniqueID : Guid.NewGuid());
            if (myNewsLetter.Mode == GlobalConfigurations.Mode.Insert)
            {
                myNewsLetter.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@NewsLettersID", myNewsLetter.UniqueID));
            parameters.Add(new SqlParameter("@EmailSubject", (string.IsNullOrEmpty(myNewsLetter.EmailSubject) ? (object)DBNull.Value : myNewsLetter.EmailSubject)));
            parameters.Add(new SqlParameter("@EmailMessage", (string.IsNullOrEmpty(myNewsLetter.EmailMessage) ? (object)DBNull.Value : myNewsLetter.EmailMessage)));
            parameters.Add(new SqlParameter("@IsNewsLetterSent", myNewsLetter.IsNewsLetterSent));
            parameters.Add(new SqlParameter("@CreatedBy", ((myNewsLetter.UserAccountID != Guid.Empty && myNewsLetter.UserAccountID != null) ? myNewsLetter.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myNewsLetter.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));

            SQLHelper.ExecuteQuery("spAddOrUpdateNewsLetters", parameters);
        }
    }
}
